function ccg=crossCorrelogram(left,right,maxlag)
% Calculate cross-correlograms from a filterbank output
% 
%   ccg=crossCorrelogram(left,right,maxlag)
% 
%   This function implements cross-correlation using "fast
%   correlation".
% 
%   ccg=crossCorrelogram(left,right,maxlag) takes left and
%   right input matrices of auditory nerve activity and
%   computes the cross-correlation over lags -maxlag:maxlag.
% 
%   The cross-correlation is calculated independently
%   between each row of left and right inputs. The output
%   ccg has the same number of rows and 2*maxlag+1 columns.
% 
%   Based on code written by Guy Brown, 25/9/99.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

[r,c]=size(left);
ccg=real(ifft(conj(fft([right zeros(r,maxlag)]')).*fft([zeros(r,maxlag) left]')))';
ccg=ccg(:,1:2*maxlag+1);

% [EOF]
