function rms = calc_rms(x,dim)
% Calculate the rms of a vector or matrix
% 
%   rms = calc_rms(x,dim)
% 
%   rms = calc_rms(x) calculates the Root Mean Square of x
%   along the first non-singleton dimension of vector or
%   matrix x. For vectors, calc_rms(x) is the RMS value of
%   the elements in x. For matrices, calc_rms(x) is a row
%   vector containing the RMS value of each column.  For N-D
%   arrays, calc_rms(x) is the RMS value of the elements
%   along the first non-singleton dimension of x.
% 
%   rms = calc_rms(x,dim) calculates the RMS of x along the
%   dimension dim.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if nargin == 1
    dim = find(size(x)~=1,1,'first');
end

rms = sqrt(mean(x.^2,dim));

% [EOF]
