function itd = azimuth2itd(azimuth,f)
% Convert azimuth in degrees to ITD
% 
%   itd = azimuth2itd(azimuth,f)
% 
%   itd = azimuth2itd(azimuth,f) converts the azimuth in
%   degrees at frequency f to interaural time difference
%   according to Kuhn's model [1].
% 
%   References
% 
%   [1] Kuhn, G.F. (1977), Model for the interaural time
%   differences in the azimuthal plane, The Journal of the
%   Acoustical Society of America 62, 1, 157-167.
% 
%   See also ITD2AZIMUTH, FREQ_MULTI.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

czero = 344;

itd = (freq_multi(f)*0.091*sind(azimuth))/czero;

% [EOF]
