function config = load_config(filename)
% Load the configuration file and write it to a structure

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

fid = fopen(filename);
if fid==-1
    error([filename 'not found'])
end
C = textscan(fid,'%s %s %s %s %s %s %s %s %s %s','delimiter',',','CollectOutput',true);
fclose(fid);

names = C{1}(1,:);

C = C{1}(2:end,:);

C2 = cell2struct(C,names,2);

config = struct;

fields = fieldnames(C2(1));

for j = 1:length(fields)
    config.(fields{j}) = cell(size(C2));
end

for i = 1:length(C2)
    for j = 1:length(fields)
        config.(fields{j}){i} = C2(i).(fields{j});
    end
end

% [EOF]
