function snr = calc_snr(output,target)
% Calculate the separation SNR
% 
%   snr = calc_snr(output,target)
% 
%   snr = calc_snr(output,target) calculate the separation
%   signal-to-noise ratio in dB for a re-synthesised output
%   compared to the ideal target. output and target should
%   be vectors.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% check input
if ~isvector(output)
    error('''output'' must be a vector')
end
if ~isvector(target)
    error('''target'' must be a vector')
end
if numel(output)~=numel(target)
    error('inputs must be the same length')
end
if size(output,1)==1
    output = output';
end
if size(target,1)==1
    target = target';
end

% remove delay caused by convolution
cc = xcorr(output.^2,target.^2);

delay = find(cc==max(cc))-length(output);

if delay > 0
        target = [zeros(delay,1); target];
        output = [output; zeros(delay,1)];
elseif delay < 0
        delay = -delay;
        output = [zeros(delay,1); output];
        target = [target; zeros(delay,1)];
end

% account for arbitrary gain
G = output\target;
output = output.*G;

snr = 10*log10(sum(target.^2)/sum((output-target).^2));

% [EOF]
