function IBMR = calc_ibmr(m,ibm)
% Calculates the Ideal Binary Mask Ratio (IBMR)
% 
%   IBMR = calc_ibmr(m,ibm)
% 
%   IBMR = calc_ibmr(m,ibm) calculates the ideal binary mask
%   ratio (IBMR) from the calculated mask m and ideal mask
%   ibm. Masks can be logical or double.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if nargin < 2
    error('You need 2 masks to calculate IBMR!')
end

if any(size(m)~=size(ibm))
    error('Masks must be the same size!')
end

if ~islogical(m)
    m = logical(m);
end

if ~islogical(ibm)
    ibm = logical(ibm);
end

lamda = sum(sum(m&ibm));
rho = sum(sum(xor(m,ibm)));

IBMR = lamda/(lamda+rho);

% [EOF]
